<?php
include("db.php"); // Include your database connection

// Start the session
session_start();
$user_id = $_SESSION['user_id'] ?? null;

// Set content type to JSON
header('Content-Type: application/json');

// Check if the method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Read the raw POST data
    $rawData = file_get_contents('php://input');
    
    // Decode the JSON data
    $data = json_decode($rawData, true);

    // Check for errors in JSON decoding
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid JSON input', 'error_detail' => json_last_error_msg()]);
        exit();
    }

    // Check for required fields and validate data
    if (!isset($data['Product_name']) || !isset($data['MRP']) || !isset($data['Price_type'])) {
        echo json_encode(['status' => 'error', 'message' => 'Required fields are missing']);
        exit();
    }

    // Assign and sanitize input data
    $productId = isset($data['Product_id']) ? (int)$data['Product_id'] : null;
    $productName = mysqli_real_escape_string($conn, $data['Product_name']);
    $mrp = (float)$data['MRP'];
    $priceType = (int)$data['Price_type']; // 1 = Inclusive, 2 = Exclusive
    $taxPercentage = isset($data['Tax_percentage']) ? (float)$data['Tax_percentage'] : 5; // Default to 5%

    // Optional fields
    $purchasePrice = isset($data['Purchase_price']) ? (float)$data['Purchase_price'] : 0;
    $variant = isset($data['Variant']) ? mysqli_real_escape_string($conn, $data['Variant']) : '';
    $productDescription = isset($data['Product_description']) ? mysqli_real_escape_string($conn, $data['Product_description']) : '';
    $hsn = isset($data['HSN']) ? mysqli_real_escape_string($conn, $data['HSN']) : '';
    $qty = isset($data['qty']) ? (int)$data['qty'] : 0;
    $category = isset($data['category']) ? mysqli_real_escape_string($conn, $data['category']) : '';
    $locationRack = isset($data['Location_rack']) ? mysqli_real_escape_string($conn, $data['Location_rack']) : '';
    $brand = isset($data['Brand']) ? mysqli_real_escape_string($conn, $data['Brand']) : '';
    $youtubeUrl = isset($data['Youtube_url']) ? mysqli_real_escape_string($conn, $data['Youtube_url']) : '';
    $barcode = isset($data['barcode']) ? mysqli_real_escape_string($conn, $data['barcode']) : '';
    $minQty = isset($data['minqty']) ? (int)$data['minqty'] : 0;
    $maxQty = isset($data['maxqty']) ? (int)$data['maxqty'] : 5;
    $packingDate = isset($data['Packing_date']) ? mysqli_real_escape_string($conn, $data['Packing_date']) : '0000-00-00';
    $expiryDate = isset($data['Expiry_date']) ? mysqli_real_escape_string($conn, $data['Expiry_date']) : '0000-00-00';
    $shippingWeight = isset($data['Shipping_weight']) ? (float)$data['Shipping_weight'] : 0;
    $ParantId = isset($data['parantid']) ? (int)($data['parantid']) : 1;

    // Initialize variables for calculations
    $price = 0;
    $taxValue = 0;
    $sellingPrice = 0;

    // Perform calculations based on Price_type
    if ($priceType == 1) { // Inclusive tax
        if (!isset($data['Selling_price'])) {
            echo json_encode(['status' => 'error', 'message' => 'Selling price is required for inclusive tax']);
            exit();
        }
        $sellingPrice = (float)$data['Selling_price'];
        $price = $sellingPrice / (1 + $taxPercentage / 100);
        $taxValue = $sellingPrice - $price;
    } elseif ($priceType == 2) { // Exclusive tax
        if (!isset($data['price'])) {
            echo json_encode(['status' => 'error', 'message' => 'Price is required for exclusive tax']);
            exit();
        }
        $price = (float)$data['price'];
        $taxValue = $price * $taxPercentage / 100;
        $sellingPrice = $price + $taxValue;
    }

    // Common calculations for discount
    $discountValue = $mrp - $sellingPrice;
    $discountPercentage = (($mrp - $sellingPrice) / $mrp * 100);

    // Handle barcode image upload
    $barcodeImagePath = null;
    if (isset($data['barcode_image']) && !empty($data['barcode_image'])) {
        $barcodeImageData = $data['barcode_image'];

        // Remove the base64 encoding prefix
        $barcodeImageData = str_replace('data:image/png;base64,', '', $barcodeImageData);

        // Decode the base64 data
        $decodedBarcodeImage = base64_decode($barcodeImageData);
        if ($decodedBarcodeImage === false) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to decode barcode image']);
            exit();
        }

        // Create a unique name for the barcode image and save it to the 'barcodes' directory
        $barcodeImageName = uniqid('', true) . '.png';
        $barcodeImagePath = 'barcodes/' . $barcodeImageName;

        // Save the barcode image to the server
        if (file_put_contents($barcodeImagePath, $decodedBarcodeImage)) {
            $barcodeImagePath = 'https://hapitest.xyz/hapi%20commers/api/' . $barcodeImagePath; // Store the full URL
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to save barcode image']);
            exit();
        }
    }

    // Handle QR code image upload
    $qrcodeImagePath = null;
    if (isset($data['qrcode_image']) && !empty($data['qrcode_image'])) {
        $qrcodeImageData = $data['qrcode_image'];

        // Remove the base64 encoding prefix
        $qrcodeImageData = str_replace('data:image/png;base64,', '', $qrcodeImageData);

        // Decode the base64 data
        $decodedQrcodeImage = base64_decode($qrcodeImageData);
        if ($decodedQrcodeImage === false) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to decode QR code image']);
            exit();
        }

        // Create a unique name for the QR code image and save it to the 'qrcodes' directory
        $qrcodeImageName = uniqid('', true) . '.png';
        $qrcodeImagePath = 'qrcode/' . $qrcodeImageName;

        // Save the QR code image to the server
        if (file_put_contents($qrcodeImagePath, $decodedQrcodeImage)) {
            $qrcodeImagePath = 'https://hapitest.xyz/hapi%20commers/api/' . $qrcodeImagePath; // Store the full URL
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to save QR code image']);
            exit();
        }
    }

    // Handle product image upload
    $productImage = null;
    if (isset($data['Product_image']) && !empty($data['Product_image'])) {
        $imageData = $data['Product_image'];

        // Remove the base64 encoding prefix
        $imageData = str_replace(['data:image/jpeg;base64,', 'data:image/png;base64,', 'data:image/jpg;base64,'], '', $imageData);

        // Decode the base64 data
        $decodedImage = base64_decode($imageData);
        if ($decodedImage === false) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to decode image']);
            exit();
        }

        // Create a unique name for the image and save it to the 'images' directory
        $imageName = uniqid('', true) . '.png';
        $imagePath = 'images/' . $imageName;

        // Save the image to the server
        if (file_put_contents($imagePath, $decodedImage)) {
            $productImage = 'https://hapitest.xyz/hapi%20commers/api/' . $imagePath; // Store the image path
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to upload image']);
            exit();
        }
    }

    // Insert query (fixing the data repetition issue)
    $result = $conn->query("SELECT SKU FROM product ORDER BY SKU DESC LIMIT 1");
    $newSKU = 'SKU-0001';
    if ($result->num_rows > 0) {
        $lastSKU = $result->fetch_assoc()['SKU'];
        $lastNumber = (int) substr($lastSKU, 4);
        $nextNumber = $lastNumber + 1;
        $newSKU = 'SKU-' . str_pad($nextNumber, 4, '0', STR_PAD_LEFT);
    }
    $createDate = date('Y-m-d H:i:s'); // Set current date and time
    $deleteStatus = 0; // Default delete status
    $sqlVariant = "INSERT INTO product_variants (Product_ID, variant, Create_Date, Delete_status) 
    VALUES ($productId, '$variant', '$createDate', $deleteStatus)";

if (mysqli_query($conn, $sqlVariant)) {
    $variantid = mysqli_insert_id($conn); // Store the inserted variant ID before any other insert

    if ($variantid == 0) {
        echo json_encode(['status' => 'error', 'message' => 'Variant insertion failed']);
        exit();
    }

    // Check if the product already has variants
    $existingVariantQuery = "SELECT variant_id FROM product WHERE Product_id = $productId";
    $existingVariantResult = mysqli_query($conn, $existingVariantQuery);

    if ($existingVariantResult && mysqli_num_rows($existingVariantResult) > 0) {
        $row = mysqli_fetch_assoc($existingVariantResult);
        $existingVariantIds = $row['variant_id'];

        // Append the new variant ID
        $variantid1 = !empty($existingVariantIds) ? $existingVariantIds . ',' . $variantid : $variantid;

        // Update product table with the variant ID
        $updateSql1 = "UPDATE product SET variant_id = '$variantid1' WHERE Product_id = '$productId'";
        if (!mysqli_query($conn, $updateSql1)) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update product with variant ID', 'error_detail' => mysqli_error($conn)]);
            exit();
        }
    }
}

// Insert into product table (DO THIS AFTER STORING VARIANT ID)
$sql = "INSERT INTO product (
    Product_name, Purchase_price, MRP, Selling_price, price, category, Variant, Product_description, M_unit, 
    HSN, SKU, qty, Price_type, Product_image, Sale_price_tax, Purchase_price_tax, Shipping_weight, Tax_percentage, 
    tax, Discount_percentage, Discount_value, Packing_date, Expiry_date, Location_rack, Brand, Youtube_url, barcode, 
    minqty, maxqty, Creater_id, Edit_id, mode, barcode_image, qrcode_image, parantid
) VALUES (
    '$productName', '$purchasePrice', '$mrp', '$sellingPrice', '$price', '$category', '$variant', '$productDescription', 
    '{$data['M_unit']}', '$hsn', '$newSKU', '$qty', '$priceType', '$productImage', '{$data['Sale_price_tax']}', 
    '{$data['Purchase_price_tax']}', '$shippingWeight', '$taxPercentage', '$taxValue', 
    '$discountPercentage', '$discountValue', '$packingDate', '$expiryDate', '$locationRack', '$brand', '$youtubeUrl', 
    '$barcode', '$minQty', '$maxQty', '$user_id', '$user_id', '{$data['mode']}', '$barcodeImagePath', '$qrcodeImagePath', 
    '$ParantId'
)";

if ($conn->query($sql) === TRUE) {
    $productId = $conn->insert_id; // Get the last inserted product ID

    // Update product_variants table (Make sure `$variantid` is stored before this)
    $updateSql = "UPDATE product_variants SET variant_Product_id = '$productId' WHERE variant_id = '$variantid'";

            if ($conn->query($updateSql) === TRUE) {
            // Insert into the inventory table
            $inventorySql = "INSERT INTO inventory (
                Product_id, Sku, Qty, date_added, date_modified, Location, Created_id, Editor_id, Delete_status
            ) VALUES (
                '$productId', '$newSKU', '$qty', NOW(), NOW(), '$locationRack', '$user_id', '$user_id', '0'
            )";

            if ($conn->query($inventorySql) === TRUE) {
                echo json_encode(['status' => 'success', 'message' => 'Product and inventory added successfully']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Product added, but failed to add to inventory', 'error_detail' => $conn->error]);
            }
            } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update product with variant ID', 'error_detail' => $conn->error]);
            }
            } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to insert product', 'error_detail' => $conn->error]);
            }
            } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to insert product variant', 'error_detail' => mysqli_error($conn)]);
            }
            


$conn->close();
?>